/*
   forward-version.h - driver for SoftLab-NSK Forward boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_VERSION_H
#define FORWARD_VERSION_H

#include <linux/kernel.h>
#include <linux/version.h>

#ifndef RHEL_RELEASE_CODE
#define RHEL_RELEASE_CODE 0
#define RHEL_RELEASE_VERSION(a, b) (((a) << 8) + (b))
#endif

#define FORWARD_VERSION_MAJOR 1
#define FORWARD_VERSION_MINOR 5
#define FORWARD_VERSION_PATCH 45

#define _FORWARD_VERSION_STR_HELPER(x) #x
#define _FORWARD_VERSION_STR(x) _FORWARD_VERSION_STR_HELPER(x)

#define FORWARD_VERSION_STRING                                                    \
	_FORWARD_VERSION_STR(FORWARD_VERSION_MAJOR)                               \
	"." _FORWARD_VERSION_STR(FORWARD_VERSION_MINOR) "." _FORWARD_VERSION_STR( \
		FORWARD_VERSION_PATCH)

#define FORWARD_VERSION_CODE                                                \
	(((FORWARD_VERSION_MAJOR) << 16) | ((FORWARD_VERSION_MINOR) << 8) | \
	 ((FORWARD_VERSION_PATCH) << 0))

#endif
