/*
   forward-v4l2-asi.h - DVB-ASI utilities for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_V4L2_ASI_H
#define FORWARD_V4L2_ASI_H

#include "forward-v4l2.h"

size_t forward_v4l2_decode_asi(const u8 *in, u8 *out, size_t in_size, size_t out_size,
			       size_t *error_count);
size_t forward_v4l2_render_asi(const u8 *in, u8 *out, size_t in_size, size_t out_size);
void forward_v4l2_clear_asi(u8 *out, size_t out_size);

#endif // FORWARD_V4L2_ASI_H
