/*
   forward-pll.h - PLL drivers for SoftLab-NSK Forward boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_PLL_H
#define FORWARD_PLL_H

#include <linux/kernel.h>

#include "forward.h"

struct forward_pll_mode;
struct forward_pll;

#define FORWARD_PLL_FEATURE_MASTER (1 << 0)
#define FORWARD_PLL_FEATURE_FALLBACK (1 << 1)
#define FORWARD_PLL_FEATURE_TUNE (1 << 2)

struct forward_pll_ops {
	struct forward_pll_mode *(*find_mode)(struct forward_pll *pll, s64 in_pix_freq,
					      s64 in_h_freq, bool in_m, s64 out_freq, bool out_m);
	int (*switch_mode)(struct forward_pll *pll, struct forward_pll_mode *mode);
	int (*select_input)(struct forward_pll *pll, int input, bool master, bool autoswitch);
	s64 (*tune)(struct forward_pll *pll, s64 ppt);
	s64 (*get_tune)(struct forward_pll *pll);
	void (*calibrate)(struct forward_pll *pll);
};

struct forward_pll {
	struct forward_dev *dev;

	int num_inputs;
	int features;

	struct forward_pll_ops *ops;
};

#endif
