/*
   forward-v4l2-utils.h - v4l2 utilities for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_V4L2_UTILS_H
#define FORWARD_V4L2_UTILS_H

#include "forward-v4l2.h"

void forward_v4l2_input_color_convert(struct vb2_buffer *buf, int offset[2], int inbytesperline,
				      int outbytesperline, int lines,
				      enum forward_v4l2_pixfmt_conv func);

void forward_v4l2_output_color_convert(struct vb2_buffer *buf, int offset[2], int inbytesperline,
				       int outbytesperline, int lines,
				       enum forward_v4l2_pixfmt_conv func);

void forward_v4l2_interleave(struct vb2_buffer *buf, int offset[2], int bytesperline, int lines,
			     bool bff);

void forward_v4l2_interleave_color_conv(struct vb2_buffer *buf, int offset[2], int inbytesperline,
					int outbytesperline, int lines,
					enum forward_v4l2_pixfmt_conv func, bool bff);

void forward_v4l2_deinterleave_color_convert(struct vb2_buffer *buf, int offset[2],
					     int inbytesperline, int outbytesperline, int lines,
					     enum forward_v4l2_pixfmt_conv func);

void forward_v4l2_unpack10b16b(const u8 *in, u8 *out, int words);
void forward_v4l2_pack16b10b(const u8 *in, u8 *out, int words);
void forward_v4l2_set16b10b(uint64_t v, u8 *out, int words);

#endif // FORWARD_V4L2_UTILS_H
