#include "ALSADevice.hpp"
#include <alsa/asoundlib.h>

ALSADevice::ALSADevice(std::string& name, snd_pcm_stream_t stream)
{
    snd_pcm_t* pcm;
    m_lastError = snd_pcm_open(&pcm, name.c_str(), stream, SND_PCM_NONBLOCK);

    if (!m_lastError) {
        m_pcm = std::shared_ptr<snd_pcm_t>(pcm, snd_pcm_close);
    }
}

bool ALSADevice::isOpen() const
{
    return m_pcm != nullptr;
}

bool ALSADevice::isError() const
{
    return !m_lastError;
}

int ALSADevice::error() const
{
    return m_lastError;
}

std::string ALSADevice::errorString() const
{
    return std::string(snd_strerror(m_lastError));
}

std::shared_ptr<snd_pcm_t> ALSADevice::pcm() const
{
    return m_pcm;
}
