#include <cstdint>
#include <map>
#include <vector>

//! Class providing parser for ST-291 packets
class ANCParser {
public:
    //! Internal representation of ST291 packet header
    struct ST291Header {
        //! Type
        uint8_t did;
        //! Subtype
        uint8_t sdid;
        //! User data length
        uint8_t dc;
        //! SDI stream
        int stream;
        //! SDI line
        int line;
        //! User data offset in buffer
        int uwoffset;
        //! Checksum correct
        bool csok;
    };
    ANCParser();

    void parse(uint8_t* data, int size, bool sd);

    ST291Header findPacket(uint8_t stream, uint8_t did);
    ST291Header findPacket(uint8_t stream, uint8_t did, int& pos);

    int extractData8bit(const ST291Header& p, uint8_t* buf, int maxsize);
    int extractData8bit(uint8_t stream, uint8_t did, uint8_t* buf, int maxsize);

    int extractHDAudioPCM(uint32_t* samples, int channels, int maxsamples);
    int extractSDAudioPCM(uint32_t* samples, int channels, int maxsamples);

private:
    std::map<uint8_t, std::vector<uint16_t>> m_data;
    std::map<uint8_t, std::vector<ST291Header>> m_packets;
};
