#include "RTPParser.hpp"

#include <cstring>

RTPParser::RTPParser()
{
}

void RTPParser::parse(uint8_t* data, int size)
{
    for (auto& kv : m_data)
        kv.second.clear();
    for (auto& kv : m_packets)
        kv.second.clear();

    uint8_t* p = data;
    int count = size;

    while (count > 0) {
        RTPHeader h;
        if ((p[0] & 0xC0 != 0x80) || (p[1] == 0x00)) {
            p += 16;
            count -= 16;
            continue;
        }
        uint8_t pt = p[1] & 0x7F;

        memcpy(&h, p, 12);
        h.length = *((uint16_t*)&p[12]);
        h.tag = p[14];
        h.offset = m_data[pt].size();

        std::copy(&p[16], p + h.length, std::back_inserter(m_data[pt]));
        m_packets[pt].push_back(h);

        int skip = (h.length + 16 + 15) & ~15;
        p += skip;
        count -= skip;
    }
}

int RTPParser::extractST2110AudioPCM24(uint32_t* samples, int channels, int maxsamples, uint8_t pt)
{
    int outi = 0;

    if (m_data.find(pt) == m_data.end())
        return 0;

    const std::vector<uint8_t>& data = m_data.at(pt);
    const std::vector<RTPHeader>& pkts = m_packets.at(pt);

    for (auto& p : pkts) {
        int left = maxsamples - outi;

        if (left <= 0)
            break;

        uint32_t* outp = &samples[outi * channels];
        const uint8_t* inp = data.data() + p.offset;
        int pktsamples = p.length / channels / 3;
        int size = std::min(left, pktsamples);

        for (int i = 0; i < size * channels; i++) {
            *outp = ((uint32_t)inp[0] << 16) | ((uint32_t)inp[1] << 8) | ((uint32_t)inp[2] << 0);
            outp++;
            inp += 3;
        }
        outi += size;
    }

    return outi;
}
