#include "Board.hpp"

#include <iostream>

/*!
 * \dir ./
 * This example shows how to use \ref Board and \ref Board::enumerate to enumerate boards in system
 */

void showInfo(const Board& b)
{
    std::vector<Board::IOMode> modes = b.ioMode();
    auto info = b.info();

    std::cout << "Board " << info.name << " (" << info.path << "): " << std::endl;
    for (int i = 0; i < info.ioCount; i++) {
        if (modes[i] == Board::IOMode::Disabled)
            continue;

        std::cout << "\tIO" << (i + 1) << ": ";
        switch (modes[i]) {
        case Board::IOMode::Input:
            std::cout << "In ";
            break;
        case Board::IOMode::Output:
            std::cout << "Out";
            break;
        default:
            std::cout << "Inv";
            break;
        }

        std::cout << " " << info.videoDevs[i] << " " << info.vbiDevs[i] << " " << info.audioDevs[i]
                  << std::endl;
    }
}

int main(int argc, char** argv)
{
    std::vector<Board::Info> boards = Board::enumerate();

    for (auto& bi : boards) {
        Board board(bi);
        showInfo(board);
    }
}
