/*
   forward-fd2110.h - SoftLab-NSK FD2110-specific interfaces

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "forward.h"

struct forward_fd2110_mixer_ops {
	bool (*get_dst)(void *private, bool ipv6, const u8 *dst_ip, u8 *dst_mac, u8 *dst_ttl);
	bool (*get_src)(void *private, bool ipv6, u8 *src_ip);
};

int forward_fd2110_in_filter_add(struct forward_dev *dev, int eth, u8 stream, u8 tag,
				 const u8 *ipv6, u16 port, void *client);
int forward_fd2110_in_filter_remove(struct forward_dev *dev, int eth, u8 stream, void *client);
void forward_fd2110_in_filter_remove_all(struct forward_dev *dev, int eth, void *client);
int forward_fd2110_in_filter_replace(struct forward_dev *dev, int eth, u8 stream, u8 tag,
				     const u8 *ipv6, u16 port, void *client);
void forward_fd2110_in_filter_print(struct forward_dev *dev, int eth);

int forward_fd2110_out_mixer_update(struct forward_dev *dev, int eth, u8 stream, u16 src_port,
				    const u8 *dst_ipv6, u16 dst_port, bool ipv6, void *client);
int forward_fd2110_out_mixer_toggle_en(struct forward_dev *dev, int eth, u8 stream, bool enabled);
void forward_fd2110_out_mixer_disable_all(struct forward_dev *dev, int eth, void *client);
void forward_fd2110_out_mixer_print(struct forward_dev *dev, int eth);
void forward_fd2110_out_mixer_set_ops(struct forward_dev *dev, int eth,
				      const struct forward_fd2110_mixer_ops *ops, void *private);

void forward_fd2110_out_toggle_protection(struct forward_dev *dev, bool enable);
