/*
   forward-mcap.c - PCIe configuration port driver for SoftLab-NSK Forward boards

   Copyright (C) 2017 - 2025 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "forward.h"

#include <linux/firmware.h>

int forward_mcap_flash_firmware(struct forward_dev *dev, const struct firmware *fw);
int forward_mcap_reboot(struct forward_dev *dev, u32 address, bool fallback);

int forward_mcap_init(struct forward_dev *dev);
void forward_mcap_fini(struct forward_dev *dev);
