/*
   forward-alsa-io.h - ALSA capture driver for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_ALSA_IO_H
#define FORWARD_ALSA_IO_H

#include "forward.h"
#include "forward-alsa.h"
#include "forward-irq.h"

struct forward_alsa_io_stats {
	int resyncs;
	bool was_resync;
	int was_resync_count;
};

struct forward_alsa_io {
	struct forward_alsa *alsa;
	void *private;

	enum forward_io_state state;
	int index;
	int number;

	struct snd_pcm *pcm;
	struct snd_pcm_substream *stream;
	struct mutex lock;
	struct forward_irq_listener irq;
	bool ready;
	bool streaming;
	int forced_channels;
	int fps_n, fps_d;
	int interlaced;
	s64 seq_n, seq_d;

	struct snd_kcontrol *ctl_force_ch;

	void *hw_buffer;
	bool hw_streaming;
	u32 hw_buffer_address;
	u32 hw_buffer_size;
	snd_pcm_format_t hw_format;
	unsigned int hw_channels;

	enum forward_alsa_stream_type type;
	int subtype;

	s64 position[FORWARD_ALSA_MAX_SDI_GROUPS];
	s64 ex_position;
	snd_pcm_sframes_t hw_rd_position, hw_wr_position;
	s64 sw_rd_position;
	s64 last_period_position[FORWARD_ALSA_MAX_SDI_GROUPS];

	u64 position_time;

	struct forward_alsa_io_stats stats;

	struct delayed_work watchdog_work;
};

#define forward_alsa_substream_io(substream) \
	((struct forward_alsa_io *)snd_pcm_substream_chip(substream))

int forward_alsa_io_init(struct forward_alsa_io *io);
void forward_alsa_io_deinit(struct forward_alsa_io *io);

#endif // FORWARD_ALSA_IO_H
