/*
   forward-hanc.c - SMPTE SDI HANC decoder

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_HANC_H
#define FORWARD_HANC_H

#include "forward.h"

#define FORWARD_HANC_MAX_SDI_STREAMS 2

struct forward_hanc_stream {
	const uint16_t *buffer;
	size_t size;
	int streams;

	int p[FORWARD_HANC_MAX_SDI_STREAMS];
};

struct forward_hanc_smpte_291_header {
	uint8_t did;
	union {
		uint8_t sdid;
		uint8_t block_number;
	};
	uint8_t data_count;
};

int forward_hanc_open(struct forward_hanc_stream *s, const uint16_t *buffer, size_t size,
		      int streams);
void forward_hanc_close(struct forward_hanc_stream *s);

bool forward_hanc_read_smpte_291_header(struct forward_hanc_stream *s, int stream,
					struct forward_hanc_smpte_291_header *h, bool sd);
bool forward_hanc_read_smpte_291_data(struct forward_hanc_stream *s, int stream,
				      struct forward_hanc_smpte_291_header *h, uint16_t *data,
				      size_t maxsize);

#endif
