/*
   forward-alsa-ioctl.h - ALSA driver controls for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_ALSA_IOCTL_H
#define FORWARD_ALSA_IOCTL_H

#include <linux/sound.h>

enum snd_forward_stream_format {
	SND_FORWARD_STREAM_FORMAT_L24 = 0,
	SND_FORWARD_STREAM_FORMAT_L20,
	SND_FORWARD_STREAM_FORMAT_L16,
	SND_FORWARD_STREAM_FORMAT_COUNT,
};

enum snd_forward_stream_period {
	SND_FORWARD_STREAM_PERIOD_1000US = 0,
	SND_FORWARD_STREAM_PERIOD_125US,
	SND_FORWARD_STREAM_PERIOD_COUNT,
};

struct snd_forward_stream_address {
	__u8 ipv6[16];
	__u16 port;
	__u8 payload_type;
} __attribute__((packed));

#endif // FORWARD_ALSA_IOCTL_H
