/*
   forward-ioctl.h - SoftLab-NSK Forward video boards driver interface

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_IOCTL_H
#define FORWARD_IOCTL_H

#include <linux/ioctl.h>
#include <linux/types.h>

#define FWIOC_REG_IO_NOOP 0x0
#define FWIOC_REG_IO_READ 0x1
#define FWIOC_REG_IO_WRITE 0x2
#define FWIOC_REG_IO_SET 0x3
#define FWIOC_REG_IO_CLEAR 0x4

struct forward_ioc_reg_io {
	__u32 op;
	__u32 reg;
	__u32 data;
	__u32 delay;
};

#define FWIOC_IRQ_FLAG_BITS (128)

struct forward_ioc_irq {
	__u32 flags[FWIOC_IRQ_FLAG_BITS / 32];
};

#define FWIOC_VDMA_DIR_HOST_TO_BOARD 0x1
#define FWIOC_VDMA_DIR_BOARD_TO_HOST 0x2
#define FWIOC_VDMA_DIR_BIDIRECTIONAL (FWIOC_VDMA_DIR_HOST_TO_BOARD | FWIOC_VDMA_DIR_BOARD_TO_HOST)

struct forward_ioc_vdma_region {
	__u64 address;
	__u64 size;
	__u32 dir;
	void *buffer;
};

#define FWIOC_BASE 0x46

#define FWIOC_CTL_BASE 0x00
#define FWIOC_CTL_END (FWIOC_CTL_BASE + 2)
#define FWIOC_VDMA_BASE 0x10
#define FWIOC_VDMA_END (FWIOC_VDMA_BASE + 5)

#define FWIOC_REG_IO_SIZE(N)                                                    \
	((((N) * (sizeof(struct forward_ioc_reg_io))) < (1 << _IOC_SIZEBITS)) ? \
		 ((N) * (sizeof(struct forward_ioc_reg_io))) :                  \
		 0)

#define FWIOC_REG_IO(N) _IOWR(FWIOC_BASE, FWIOC_CTL_BASE + 0, char[FWIOC_REG_IO_SIZE(N)])
#define FWIOC_IRQ_ENABLE _IOW(FWIOC_BASE, FWIOC_CTL_BASE + 1, struct forward_ioc_irq)
#define FWIOC_IRQ_DISABLE _IOW(FWIOC_BASE, FWIOC_CTL_BASE + 2, struct forward_ioc_irq)

#define FWIOC_VDMA_GET_REGION _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 0, struct forward_ioc_vdma_region)
#define FWIOC_VDMA_PUT_REGION _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 1, struct forward_ioc_vdma_region)
#define FWIOC_VDMA_PUT_ALL_REGIONS _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 2, __u32)
#define FWIOC_VDMA_MAP _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 3, struct forward_ioc_vdma_region)
#define FWIOC_VDMA_UNMAP _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 4, struct forward_ioc_vdma_region)
#define FWIOC_VDMA_SYNC _IOW(FWIOC_BASE, FWIOC_VDMA_BASE + 5, struct forward_ioc_vdma_region)

#endif
